# Nine Three Merch - Image Guide

## 📸 Adding Real Product Images

This guide explains how to add real product images to your Nine Three Merch website.

## Directory Structure

All images are organized in the `public/images/` directory:

```
public/images/
├── products/        # Product images
├── gallery/         # Gallery/portfolio images
├── services/        # Service showcase images
├── team/           # Team member photos
├── logos/          # Company logos
└── testimonials/   # Customer photos (optional)
```

## Product Images

### Required Images

Each product in `lib/data/products.ts` references an image. Replace placeholder URLs with real images:

#### Apparel
- `logo-tee.jpg` - Nine Three Classic Logo Tee
- `hoodie-black.jpg` - Nine Three Hoodie - Black Edition
- `snapback.jpg` - Nine Three Snapback
- `work-shirt.jpg` - Mechanic Work Shirt
- `beanie.jpg` - Nine Three Beanie

#### Detailing Products
- `care-kit.jpg` - Premium Car Care Kit
- `ceramic-coating.jpg` - Ceramic Coating Kit
- `microfiber-towels.jpg` - Microfiber Towel Set
- `wax-collection.jpg` - Premium Wax Collection
- `interior-cleaner.jpg` - Interior Cleaner Spray
- `leather-conditioner.jpg` - Leather Conditioner
- `glass-cleaner.jpg` - Glass Cleaner Pro

#### Accessories
- `sticker-pack.jpg` - Nine Three Vinyl Sticker Pack
- `air-freshener.jpg` - Premium Air Freshener Set
- `keychain.jpg` - Nine Three Keychain
- `plate-frame.jpg` - License Plate Frame
- `phone-mount.jpg` - Phone Mount

#### Tools
- `foam-cannon.jpg` - Professional Foam Cannon
- `brush-set.jpg` - Detailing Brush Set
- `polisher.jpg` - Dual Action Polisher

### Image Requirements

- **Format**: JPG or PNG (JPG preferred for photos)
- **Dimensions**: 800x800px minimum (square aspect ratio)
- **File Size**: Optimize to under 500KB per image
- **Quality**: High resolution, well-lit, professional appearance

### How to Add Images

1. **Prepare your images**: 
   - Crop to square aspect ratio (1:1)
   - Resize to 1200x1200px for best quality
   - Optimize file size (use tools like TinyPNG or ImageOptim)

2. **Name your files** exactly as listed above

3. **Place images** in the correct directory:
   ```
   public/images/products/logo-tee.jpg
   public/images/products/hoodie-black.jpg
   etc...
   ```

4. **Test** by running the development server:
   ```bash
   npm run dev
   ```

## Gallery Images

For the gallery page, add before/after photos of your detailing work:

1. Create numbered folders in `public/images/gallery/`:
   ```
   public/images/gallery/
   ├── project-1/
   │   ├── before.jpg
   │   └── after.jpg
   ├── project-2/
   │   ├── before.jpg
   │   └── after.jpg
   └── ...
   ```

2. Update `app/gallery/page.tsx` with real project information

## Service Images

Add images showcasing your services:
- `basic-wash.jpg` - Action shot of basic wash service
- `premium-wash.jpg` - Premium wash & wax in progress
- `paint-correction.jpg` - Paint correction results
- `interior-basic.jpg` - Interior cleaning
- `interior-deep.jpg` - Deep cleaning process
- `ceramic-coating.jpg` - Ceramic coating application
- `ppf.jpg` - Paint protection film installation
- `showroom-detail.jpg` - Complete detail results
- `monthly-plan.jpg` - Monthly maintenance visual

## Image Optimization Tips

### Using Online Tools:
1. **TinyPNG** (tinypng.com) - Compress PNG and JPG files
2. **Squoosh** (squoosh.app) - Advanced image optimization
3. **ImageOptim** (Mac) or **FileOptimizer** (Windows)

### Command Line (if you have ImageMagick):
```bash
# Resize and optimize all JPGs in a folder
mogrify -resize 1200x1200 -quality 85 *.jpg
```

### Next.js Image Optimization:
The website uses Next.js Image component which automatically:
- Lazy loads images
- Serves responsive sizes
- Converts to modern formats (WebP)

## Placeholder System

If an image is missing, the website automatically shows a placeholder with the product name. This allows the site to function while you add real images.

## Company Logo

Add your company logo as:
- `public/images/logos/nine-three-logo.png` (transparent PNG)
- `public/images/logos/nine-three-logo-white.png` (white version for dark backgrounds)

## Best Practices

1. **Consistency**: Use similar lighting and background for product photos
2. **Quality**: Ensure images are sharp and well-composed
3. **Branding**: Include Nine Three branding where appropriate
4. **Alt Text**: The website automatically uses product names as alt text
5. **Performance**: Keep total page weight under 3MB

## Testing Your Images

After adding images:

1. Clear browser cache
2. Run the development server: `npm run dev`
3. Check each page:
   - Homepage: Featured products display correctly
   - Shop: All products show images
   - Gallery: Portfolio images load
   - Services: Service images appear

## Need Help?

If images aren't displaying:
1. Check file names match exactly (case-sensitive)
2. Verify images are in the correct folder
3. Ensure file extensions are lowercase (.jpg not .JPG)
4. Check browser console for errors
5. Try hard refresh (Ctrl+Shift+R or Cmd+Shift+R)

## Sample Image Sources

For testing, you can use free stock photos from:
- Unsplash (unsplash.com) - Search "car detailing"
- Pexels (pexels.com) - Search "auto care"
- For products, photograph your actual inventory

Remember to replace all placeholder images with real photos of your products and services before launching!
